package com.digiwin.athena.framework.rw.utils;

import cn.hutool.core.util.IdUtil;


/**
 * ID生成器
 */
public class IdGenerator {

    /**
     * 获取雪花算法ID
     * PS：IdUtil.getSnowflakeNextId() 注释有误，实际上 DataCenter Id 和 Worker Id 基于MAC地址和进程ID生成
     *
     * @return 雪花算法ID
     */
    public static long getSnowflakeId() {
        return IdUtil.getSnowflakeNextId();
    }

    /**
     * 模运算获取分片号（当分片数量为2的幂次方时）
     * 模运算优化为位运算提高性能
     *
     * @param key       分片键
     * @param tableNums 分片数量
     * @return 分片号
     */
    private static int getShardByModFor2Power(int key, int tableNums) {
        return key & (tableNums - 1);
    }

    /**
     * 模运算获取分片号
     *
     * @param key       分片键
     * @param tableNums 分片数量
     * @return 分片号
     */
    public static int getShardByMod(int key, int tableNums) {
        return key % tableNums;
    }

    private IdGenerator() {
    }

}
