package com.digiwin.athena.framework.rw.contants;

import lombok.Getter;
import lombok.RequiredArgsConstructor;

@Getter
@RequiredArgsConstructor
public enum ReadType {
    /**
     * 读旧表
     */
    OLD("old"),
    /**
     * 读新表
     */
    NEW("new");

    private final String key;

    public static ReadType valueOfKey(String key) {
        for (ReadType type : ReadType.values()) {
            if (type.getKey().equalsIgnoreCase(key)) {
                return type;
            }
        }
        throw new IllegalArgumentException("No ReadType constant for key: " + key);
    }
}