package com.digiwin.athena.framework.rw.context;

import com.digiwin.athena.framework.rw.dto.ReadWriterDto;

public class RWContextHolder {

    private static RWContext delegate = new DefaultRWContext();

    public static void setDelegate(RWContext context) {
        delegate = context;
    }

    public static void setDataSourceType(ReadWriterDto readWriterDto) {
        delegate.setDataSourceType(readWriterDto);
    }

    public static ReadWriterDto getDataSourceType() {
        return delegate.getDataSourceType();
    }

    public static void clearDataSourceType() {
        delegate.clearDataSourceType();
    }
}
