package com.digiwin.athena.framework.rw.router;

import lombok.Data;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;

import java.util.List;
import java.util.Map;

@Data
@Configuration
@ConfigurationProperties(prefix = "athena.dbswitch")
@ConditionalOnProperty(prefix = "athena.dbswitch", name = "enable", havingValue = "true", matchIfMissing = false)
public class DbSwitchConfig {

    private boolean enable;
    private String oldDatasourceName;
    private String newDatasourceName;
    /**
     * 可选值: old、new
     */
    private String readMode;
    /**
     * 可选值: old、new、both
     */
    private String writeMode;
    /**
     * 老表名 -> 新表名映射
     */
    private Map<String, String> tableMapping;

    /**
     * 需要扫描的mapper包，用于区别atmc的business的mapper防止重名表错乱
     */
    private List<String> mapperBasePackages;

}