package com.digiwin.athena.framework.rw.router;

import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.digiwin.athena.framework.rw.contants.ReadType;
import com.digiwin.athena.framework.rw.contants.WriteType;
import com.digiwin.athena.framework.rw.router.DbSwitchConfig;
import com.digiwin.athena.framework.rw.strategy.AbstractShardStrategy;
import com.digiwin.athena.framework.rw.strategy.ShardStrategyContext;
import lombok.Getter;
import org.apache.ibatis.mapping.BoundSql;

@Getter
public class MySqlReplaceTableNameVisitor extends MySqlASTVisitorAdapter {
    private final BoundSql boundSql;
    private DbSwitchConfig dbSwitchConfig;
    private String tableName;

    public MySqlReplaceTableNameVisitor(BoundSql boundSql, DbSwitchConfig dbSwitchConfig) {
        this.boundSql = boundSql;
        this.dbSwitchConfig = dbSwitchConfig;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        tableName = ShardStrategyContext.handleName(x.getExpr().toString());
        AbstractShardStrategy shardStrategy = ShardStrategyContext.getStrategyByTableName(tableName);
        shardStrategy.replaceTableName(x, boundSql, dbSwitchConfig);
        return true;
    }

}
