/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.rw.strategy;

import com.digiwin.athena.framework.rw.strategy.AbstractShardStrategy;
import com.digiwin.athena.framework.rw.strategy.DefaultShardStrategy;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.NonNull;

public class ShardStrategyContext {
    private static final Map<String, AbstractShardStrategy> MAPPINGS = new ConcurrentHashMap<String, AbstractShardStrategy>();

    public static void registerStrategy(@NonNull String tableName, @NonNull AbstractShardStrategy strategy) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        if (strategy == null) {
            throw new NullPointerException("strategy is marked non-null but is null");
        }
        MAPPINGS.putIfAbsent(tableName, strategy);
    }

    public static AbstractShardStrategy getStrategyByTableName(@NonNull String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName is marked non-null but is null");
        }
        return Optional.ofNullable(MAPPINGS.get(ShardStrategyContext.handleName(tableName))).orElse(DefaultShardStrategy.INSTANCE);
    }

    public static String handleName(String ident) {
        int len = ident.length();
        if (ident.charAt(0) == '[' && ident.charAt(len - 1) == ']') {
            ident = ident.substring(1, len - 1);
        } else {
            boolean flag0 = false;
            boolean flag1 = false;
            boolean flag2 = false;
            boolean flag3 = false;
            for (int i = 0; i < len; ++i) {
                char ch = ident.charAt(i);
                if (ch == '\"') {
                    flag0 = true;
                    continue;
                }
                if (ch == '`') {
                    flag1 = true;
                    continue;
                }
                if (ch == ' ') {
                    flag2 = true;
                    continue;
                }
                if (ch != '\'') continue;
                flag3 = true;
            }
            if (flag0) {
                ident = ident.replaceAll("\"", "");
            }
            if (flag1) {
                ident = ident.replaceAll("`", "");
            }
            if (flag2) {
                ident = ident.replaceAll(" ", "");
            }
            if (flag3) {
                ident = ident.replaceAll("'", "");
            }
        }
        return ident;
    }

    static {
        ShardStrategyContext.registerStrategy("_DEFAULT", DefaultShardStrategy.INSTANCE);
    }
}

