package com.digiwin.athena.framework.rw.context;

import com.digiwin.athena.framework.rw.dto.ReadWriterDto;
import com.jugg.agile.framework.core.util.concurrent.JaThreadLocal;

public class DefaultRWContext implements RWContext {

    private static final JaThreadLocal<ReadWriterDto> contextHolder = new JaThreadLocal<>();

    @Override
    public void setDataSourceType(ReadWriterDto readWriterDto) {
        contextHolder.set(readWriterDto);
    }

    @Override
    public ReadWriterDto getDataSourceType() {
        return contextHolder.get();
    }

    @Override
    public void clearDataSourceType() {
        contextHolder.remove();
    }
}
