/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.rw.router;

import com.alibaba.druid.sql.ast.statement.SQLExprTableSource;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.digiwin.athena.framework.rw.router.DbSwitchConfig;
import com.digiwin.athena.framework.rw.strategy.AbstractShardStrategy;
import com.digiwin.athena.framework.rw.strategy.ShardStrategyContext;
import org.apache.ibatis.mapping.BoundSql;

public class MySqlReplaceTableNameVisitor
extends MySqlASTVisitorAdapter {
    private final BoundSql boundSql;
    private DbSwitchConfig dbSwitchConfig;
    private String tableName;

    public MySqlReplaceTableNameVisitor(BoundSql boundSql, DbSwitchConfig dbSwitchConfig) {
        this.boundSql = boundSql;
        this.dbSwitchConfig = dbSwitchConfig;
    }

    public boolean visit(SQLExprTableSource x) {
        this.tableName = ShardStrategyContext.handleName(x.getExpr().toString());
        AbstractShardStrategy shardStrategy = ShardStrategyContext.getStrategyByTableName(this.tableName);
        shardStrategy.replaceTableName(x, this.boundSql, this.dbSwitchConfig);
        return true;
    }

    public BoundSql getBoundSql() {
        return this.boundSql;
    }

    public DbSwitchConfig getDbSwitchConfig() {
        return this.dbSwitchConfig;
    }

    public String getTableName() {
        return this.tableName;
    }
}

