/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.rw;

import com.alibaba.druid.DbType;
import com.alibaba.druid.util.JdbcConstants;
import com.digiwin.athena.framework.rw.BaseInterceptor;
import com.digiwin.athena.framework.rw.ShardProcessor;
import com.digiwin.athena.framework.rw.router.DataSourRouter;
import com.digiwin.athena.framework.rw.router.DbSwitchConfig;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class ShardPlugin
extends BaseInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ShardPlugin.class);
    public static final DbType DB_TYPE = JdbcConstants.MYSQL;

    public ShardPlugin(DataSourRouter dataSourRouter, DbSwitchConfig dbSwitchConfig) {
        this.dataSourRouter = dataSourRouter;
        this.dbSwitchConfig = dbSwitchConfig;
    }

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)this.realTarget(invocation.getTarget());
        MetaObject metaObject = SystemMetaObject.forObject((Object)statementHandler);
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        String mapperClassName = this.getMapperClassName(mappedStatement.getId());
        boolean shouldIntercept = this.shouldIntercept(mapperClassName);
        if (!shouldIntercept) {
            return invocation.proceed();
        }
        try {
            SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
            if (sqlCommandType == SqlCommandType.SELECT) {
                this.processRead(metaObject);
            } else if (Arrays.asList(SqlCommandType.INSERT, SqlCommandType.UPDATE, SqlCommandType.DELETE).contains(sqlCommandType)) {
                this.processWrite(metaObject, invocation);
            }
        }
        catch (Exception e) {
            log.error("[shard-plugin] ERROR", (Throwable)e);
        }
        return invocation.proceed();
    }

    private void processRead(MetaObject metaObject) {
        ShardProcessor shardProcessor = new ShardProcessor(metaObject, this.dbSwitchConfig);
        shardProcessor.route();
    }

    private void processWrite(MetaObject metaObject, Invocation invocation) throws SQLException {
        ShardProcessor shardProcessor = new ShardProcessor(metaObject, this.dbSwitchConfig);
        shardProcessor.processParams();
        shardProcessor.processWrite(this.dataSourRouter);
    }

    private Object handleDualWrite(Invocation invocation, MetaObject metaObject) throws Throwable {
        Object result = null;
        result = invocation.proceed();
        try {
            invocation.proceed();
        }
        catch (Exception e) {
            log.warn("[shard-plugin] \u53cc\u5199 second \u6570\u636e\u6e90\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return result;
    }

    private <T> T realTarget(Object target) {
        if (Proxy.isProxyClass(target.getClass())) {
            MetaObject metaObject = SystemMetaObject.forObject((Object)target);
            return this.realTarget(metaObject.getValue("h.target"));
        }
        return (T)target;
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ShardPlugin)) {
            return false;
        }
        ShardPlugin other = (ShardPlugin)o;
        return other.canEqual(this);
    }

    protected boolean canEqual(Object other) {
        return other instanceof ShardPlugin;
    }

    public int hashCode() {
        boolean result = true;
        return 1;
    }

    public String toString() {
        return "ShardPlugin()";
    }
}

