/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.rw.router;

import com.digiwin.athena.framework.rw.RWSetUpConfigUpdater;
import com.digiwin.athena.framework.rw.RWTypeInterceptor;
import com.digiwin.athena.framework.rw.ShardPlugin;
import com.digiwin.athena.framework.rw.router.DataSourRouter;
import com.digiwin.athena.framework.rw.router.DbSwitchConfig;
import com.digiwin.athena.framework.rw.router.MybatisInterceptorInit;
import java.util.List;
import javax.sql.DataSource;
import org.apache.ibatis.session.SqlSessionFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={DbSwitchConfig.class})
@ConditionalOnProperty(prefix="athena.dbswitch", name={"enable"}, havingValue="true", matchIfMissing=false)
public class DataSourRouterConfig {
    private ApplicationContext applicationContext;
    private DbSwitchConfig dbSwitchConfig;

    public DataSourRouterConfig(ApplicationContext applicationContext, DbSwitchConfig dbSwitchConfig) {
        this.applicationContext = applicationContext;
        this.dbSwitchConfig = dbSwitchConfig;
    }

    @Bean
    public RWTypeInterceptor rwTypeInterceptor(DataSourRouter dataSourRouter, DbSwitchConfig dbSwitchConfig) {
        return new RWTypeInterceptor(dataSourRouter, dbSwitchConfig);
    }

    @Bean
    public ShardPlugin shardPlugin(DataSourRouter dataSourRouter, DbSwitchConfig dbSwitchConfig) {
        return new ShardPlugin(dataSourRouter, dbSwitchConfig);
    }

    @Bean
    public MybatisInterceptorInit mybatisInterceptorInit(List<SqlSessionFactory> sqlSessionFactoryList, ShardPlugin shardPlugin, RWTypeInterceptor rwTypeInterceptor) {
        return new MybatisInterceptorInit(sqlSessionFactoryList, shardPlugin, rwTypeInterceptor);
    }

    @Bean(name={"dataSourRouter"})
    public DataSourRouter dataSourRouter() {
        String oldName = this.dbSwitchConfig.getOldDatasourceName();
        String newName = this.dbSwitchConfig.getNewDatasourceName();
        DataSource oldDs = this.getDataSourceByBeanName(oldName);
        DataSource newDs = this.getDataSourceByBeanName(newName);
        DataSourRouter dataSourRouter = new DataSourRouter(oldDs, newDs);
        return dataSourRouter;
    }

    @Bean
    public RWSetUpConfigUpdater rwSetUpConfigUpdater() {
        return new RWSetUpConfigUpdater();
    }

    private DataSource getDataSourceByBeanName(String beanName) {
        if (!this.applicationContext.containsBean(beanName)) {
            throw new IllegalArgumentException("\u6570\u636e\u6e90Bean\u4e0d\u5b58\u5728: " + beanName);
        }
        Object bean = this.applicationContext.getBean(beanName);
        if (!(bean instanceof DataSource)) {
            throw new IllegalArgumentException("Bean\u4e0d\u662fDataSource\u7c7b\u578b: " + beanName);
        }
        return (DataSource)bean;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public DbSwitchConfig getDbSwitchConfig() {
        return this.dbSwitchConfig;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public void setDbSwitchConfig(DbSwitchConfig dbSwitchConfig) {
        this.dbSwitchConfig = dbSwitchConfig;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DataSourRouterConfig)) {
            return false;
        }
        DataSourRouterConfig other = (DataSourRouterConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        DbSwitchConfig this$dbSwitchConfig = this.getDbSwitchConfig();
        DbSwitchConfig other$dbSwitchConfig = other.getDbSwitchConfig();
        return !(this$dbSwitchConfig == null ? other$dbSwitchConfig != null : !((Object)this$dbSwitchConfig).equals(other$dbSwitchConfig));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DataSourRouterConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        DbSwitchConfig $dbSwitchConfig = this.getDbSwitchConfig();
        result = result * 59 + ($dbSwitchConfig == null ? 43 : ((Object)$dbSwitchConfig).hashCode());
        return result;
    }

    public String toString() {
        return "DataSourRouterConfig(applicationContext=" + this.getApplicationContext() + ", dbSwitchConfig=" + this.getDbSwitchConfig() + ")";
    }
}

