/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.rw;

import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.stat.TableStat;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.framework.rw.ShardPlugin;
import com.digiwin.athena.framework.rw.contants.ReadType;
import com.digiwin.athena.framework.rw.contants.WriteType;
import com.digiwin.athena.framework.rw.exception.MyBatisShardException;
import com.digiwin.athena.framework.rw.router.DataSourRouter;
import com.digiwin.athena.framework.rw.router.DbSwitchConfig;
import com.digiwin.athena.framework.rw.router.MySqlReplaceTableNameVisitor;
import com.digiwin.athena.framework.rw.strategy.AbstractShardStrategy;
import com.digiwin.athena.framework.rw.strategy.ShardStrategyContext;
import com.digiwin.athena.framework.rw.utils.CommonUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import lombok.NonNull;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.scripting.defaults.DefaultParameterHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class ShardProcessor {
    private static final Logger log = LoggerFactory.getLogger(ShardProcessor.class);
    private final MetaObject metaObject;
    private DbSwitchConfig dbSwitchConfig;
    private final BoundSql boundSql;
    private final MappedStatement mappedStatement;
    private final String originalSql;
    private final String shardSql;

    public ShardProcessor(@NonNull MetaObject metaObject, DbSwitchConfig dbSwitchConfig) {
        if (metaObject == null) {
            throw new NullPointerException("metaObject is marked non-null but is null");
        }
        this.dbSwitchConfig = dbSwitchConfig;
        this.metaObject = metaObject;
        this.boundSql = (BoundSql)metaObject.getValue("delegate.boundSql");
        this.mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        this.originalSql = this.boundSql.getSql();
        this.shardSql = this.calculateShardSql();
    }

    private String calculateShardSql() {
        List<SQLStatement> stmtList = this.getSqlStatementList();
        for (SQLStatement stmt : stmtList) {
            stmt.accept((SQLASTVisitor)new MySqlReplaceTableNameVisitor(this.boundSql, this.dbSwitchConfig));
        }
        return SQLUtils.toMySqlString((SQLObject)((SQLObject)stmtList.get(0)));
    }

    public void route() {
        ReadType readType = ReadType.valueOfKey(this.dbSwitchConfig.getReadMode());
        switch (readType) {
            case OLD: {
                return;
            }
            case NEW: {
                this.setShardSql();
                return;
            }
        }
        throw new MyBatisShardException("\u672a\u77e5ReadType\uff1a" + this.dbSwitchConfig.getReadMode());
    }

    private void setShardSql() {
        this.metaObject.setValue("delegate.boundSql.sql", (Object)this.shardSql);
    }

    public void processParams() {
        SQLStatement stmt = this.getSqlStatement();
        SchemaStatVisitor schemaStatVisitor = SQLUtils.createSchemaStatVisitor((DbType)ShardPlugin.DB_TYPE);
        stmt.accept((SQLASTVisitor)schemaStatVisitor);
        Map tables = schemaStatVisitor.getTables();
        for (TableStat.Name name : tables.keySet()) {
            AbstractShardStrategy shardStrategy = ShardStrategyContext.getStrategyByTableName(name.getName());
            shardStrategy.processParams(this.metaObject, this.boundSql, schemaStatVisitor);
        }
    }

    private List<SQLStatement> getSqlStatementList() {
        List stmtList = SQLUtils.parseStatements((String)this.originalSql, (DbType)ShardPlugin.DB_TYPE);
        Assert.notEmpty((Collection)stmtList, (String)("stmtList is empty, sql: " + this.originalSql));
        return stmtList;
    }

    private SQLStatement getSqlStatement() {
        List<SQLStatement> stmtList = this.getSqlStatementList();
        Assert.notEmpty(stmtList, (String)("stmtList is empty, sql: " + this.originalSql));
        return stmtList.get(0);
    }

    public void processWrite(DataSourRouter dataSourRouter) throws SQLException {
        WriteType writeType = WriteType.valueOfKey(this.dbSwitchConfig.getWriteMode());
        switch (writeType) {
            case OLD: {
                return;
            }
            case NEW: {
                this.setShardSql();
                return;
            }
            case NEWOLD: {
                this.setShardSql();
                Connection oldConnection = dataSourRouter.getOldDs().getConnection();
                this.writeShard(oldConnection, this.originalSql);
                return;
            }
            case OLDNEW: {
                Connection newConnection = dataSourRouter.getNewDs().getConnection();
                this.writeShard(newConnection, this.shardSql);
                return;
            }
        }
        throw new MyBatisShardException("\u672a\u77e5WriteType\uff1a" + this.dbSwitchConfig.getWriteMode());
    }

    private void writeShard(Connection connection, String sql) {
        Object parameterObject = this.boundSql.getParameterObject();
        log.info("[rw-plugin] double write sql: {} \n  parameterObject({}): {}", new Object[]{CommonUtils.removeBreakingWhitespace(sql), parameterObject.getClass().getSimpleName(), JSON.toJSONString((Object)parameterObject)});
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            DefaultParameterHandler parameterHandler = new DefaultParameterHandler(this.mappedStatement, parameterObject, this.boundSql);
            parameterHandler.setParameters(statement);
            statement.executeUpdate();
        }
        catch (Exception e) {
            throw new MyBatisShardException(String.format("Error: Method ShardPlugin.write execution error of sql : \n %s \n", CommonUtils.removeBreakingWhitespace(this.shardSql)), e);
        }
    }
}

