package com.digiwin.athena.framework.snowflake;

import com.digiwin.athena.framework.snowflake.enums.DefaultBizKey;
import com.digiwin.athena.framework.snowflake.handler.AthenaWorkerIdHandler;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.JaSnowflakeId;

/**
 * 雪花算法容器 - 支持枚举化业务键和动态扩展
 *
 * @author wzq
 */
public class AthenaSnowflake {

    /**
     * 获取预定义业务键的ID生成器
     *
     * @param bizKey 业务键枚举
     * @return 雪花算法实例
     */
    public static JaSnowflakeId get(SnowflakeBizKey bizKey) {
        JaSnowflakeId generator = bizKey.getSnowflakeId();
        if (generator == null) {
            throw new IllegalArgumentException("未注册的业务键: " + bizKey);
        }
        return generator;
    }


    /**
     * 快捷生成ID (预定义业务键)
     *
     * @param bizKey 业务键枚举
     * @return 生成的ID
     */
    public static long nextId(SnowflakeBizKey bizKey) {
        return get(bizKey).get();
    }


    // ===================== 使用示例 =====================
    public static void main(String[] args) {
        AthenaWorkerIdHandler.INSTANCE.setWorkerId(0);
        System.out.println(AthenaSnowflake.nextId(DefaultBizKey.DEFAULT_MODULE_A));
        System.out.println(AthenaSnowflake.nextId(DefaultBizKey.DEFAULT_MODULE_B));
    }
}