package com.digiwin.athena.framework.snowflake.enums;

import com.digiwin.athena.framework.snowflake.handler.AthenaWorkerIdHandler;
import com.digiwin.athena.framework.snowflake.SnowflakeBizKey;
import com.digiwin.athena.framework.snowflake.utils.ConfigUtil;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.JaSnowflakeId;

/**
 * @author wzq
 */
public enum DefaultBizKey implements SnowflakeBizKey {
    DEFAULT_MODULE_A("default_module_a", JaSnowflakeId.newInstance(
            ConfigUtil.createDefaultA(),
            AthenaWorkerIdHandler.INSTANCE)),
    DEFAULT_MODULE_B("default_module_b", JaSnowflakeId.newInstance(
            ConfigUtil.createDefaultB(),
            AthenaWorkerIdHandler.INSTANCE));

    private final String keyName;
    private final JaSnowflakeId snowflakeId;

    DefaultBizKey(String keyName, JaSnowflakeId snowflakeId) {
        this.keyName = keyName;
        this.snowflakeId = snowflakeId;
    }

    @Override
    public String getKeyName() {
        return keyName;
    }

    @Override
    public JaSnowflakeId getSnowflakeId() {
        return snowflakeId;
    }
}