package com.digiwin.athena.framework.snowflake.handler;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.WorkerIdConfig;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.WorkerIdHandler;

/**
 * @author wzq
 */
public class AthenaWorkerIdHandler implements WorkerIdHandler {

    public static final AthenaWorkerIdHandler INSTANCE = new AthenaWorkerIdHandler();

    private volatile Integer workerId;

    @Override
    public WorkerIdConfig create() {
        // 默认某个业务最大有64台机器
        long workerIdBit = JaProperty.getLong("athena.snowflake.workerIdBit", 6L);
        return WorkerIdConfig.builder()
                .workerId(workerId)
                .workerIdBit(workerIdBit)
                .build();
    }

    /**
     * 设置工作节点ID (线程安全)
     *
     * @param workerId 工作节点ID
     */
    public void setWorkerId(Integer workerId) {
        this.workerId = workerId;
    }
}
