package com.digiwin.athena.framework.snowflake.enums;

import com.digiwin.athena.framework.snowflake.SnowflakeBizKey;
import com.digiwin.athena.framework.snowflake.utils.AthenaSnowflakeUtil;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.JaSnowflakeId;

import static com.digiwin.athena.framework.snowflake.utils.AthenaSnowflakeUtil.createDefaultA;
import static com.digiwin.athena.framework.snowflake.utils.AthenaSnowflakeUtil.createDefaultB;

/**
 * @author wzq
 */
public enum DefaultBizKey implements SnowflakeBizKey {
    DEFAULT_MODULE_A("default_module_a", AthenaSnowflakeUtil.newInstance(createDefaultA())),
    DEFAULT_MODULE_B("default_module_b", AthenaSnowflakeUtil.newInstance(createDefaultB()));

    private final String keyName;
    private final JaSnowflakeId snowflakeId;

    DefaultBizKey(String keyName, JaSnowflakeId snowflakeId) {
        this.keyName = keyName;
        this.snowflakeId = snowflakeId;
    }

    @Override
    public String getKeyName() {
        return keyName;
    }

    @Override
    public JaSnowflakeId getSnowflakeId() {
        return snowflakeId;
    }
}