package com.digiwin.athena.framework.snowflake.utils;

import com.digiwin.athena.framework.snowflake.handler.AthenaWorkerIdHandler;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.JaSnowflakeId;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.JaSnowflakeIdConfig;

/**
 * @author wzq
 */
public class AthenaSnowflakeUtil {

    public static JaSnowflakeIdConfig create(String beginTimeStr) {
        JaSnowflakeIdConfig config = new JaSnowflakeIdConfig();
        config.setBeginTimeStr(beginTimeStr);
        config.setSequenceNumberBit(6);
        config.setTimeUnit(1);
        return config;
    }

    /**
     * 适合ptm
     * @return
     */
    public static JaSnowflakeIdConfig createDefaultA() {
        JaSnowflakeIdConfig config = new JaSnowflakeIdConfig();
        config.setBeginTimeStr("2020-12-20 20:20:20");
        config.setSequenceNumberBit(6);
        config.setTimeUnit(1);
        return config;
    }

    /**
     * 适合小ai atmc等
     * @return
     */
    public static JaSnowflakeIdConfig createDefaultB() {
        JaSnowflakeIdConfig config = new JaSnowflakeIdConfig();
        config.setBeginTimeStr("2018-12-16 21:08:16");
        config.setSequenceNumberBit(6);
        config.setTimeUnit(1);
        return config;
    }

    public static JaSnowflakeId newInstance(JaSnowflakeIdConfig config) {
        return JaSnowflakeId.newInstance(config, AthenaWorkerIdHandler.INSTANCE);
    }
}
