package com.digiwin.athena.framework.snowflake;

import com.digiwin.athena.framework.snowflake.enums.DefaultBizKey;
import com.digiwin.athena.framework.snowflake.handler.AthenaWorkerIdHandler;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.JaSnowflakeId;

/**
 * 雪花算法入口类
 * 提供全局访问点获取不同业务的ID生成器
 *
 * @author wzq
 */
public class AthenaSnowflake {

    /**
     * 获取指定业务键的雪花算法实例
     *
     * @param bizKey 业务键（枚举值）
     * @return 配置好的雪花算法实例
     * @throws IllegalArgumentException 如果业务键未注册
     */
    public static JaSnowflakeId get(SnowflakeBizKey bizKey) {
        JaSnowflakeId generator = bizKey.getSnowflakeId();
        if (generator == null) {
            throw new IllegalArgumentException("未注册的业务键: " + bizKey);
        }
        return generator;
    }


    /**
     * 快速生成分布式ID
     *
     * @param bizKey 业务键（枚举值）
     * @return 生成的64位唯一ID
     */
    public static long nextId(SnowflakeBizKey bizKey) {
        return get(bizKey).get();
    }


    // ===================== 使用示例 =====================
    public static void main(String[] args) {
        // 设置工作节点ID（实际由监听器自动设置）
        AthenaWorkerIdHandler.INSTANCE.setWorkerId(0);

        // 生成模块A的ID
        System.out.println(AthenaSnowflake.nextId(DefaultBizKey.DEFAULT_MODULE_A));
        // 生成模块B的ID
        System.out.println(AthenaSnowflake.nextId(DefaultBizKey.DEFAULT_MODULE_B));
    }
}