package com.digiwin.athena.framework.snowflake.handler;

import com.digiwin.athena.framework.snowflake.exception.SnowflakeInitException;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.WorkerIdConfig;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.WorkerIdHandler;

/**
 * Athena工作节点ID处理器
 * 负责提供雪花算法的工作节点配置
 *
 * @author wzq
 */
public class AthenaWorkerIdHandler implements WorkerIdHandler {
    // 单例实例
    public static final AthenaWorkerIdHandler INSTANCE = new AthenaWorkerIdHandler();
    // 当前工作节点ID（线程安全）
    private volatile Integer workerId;

    /**
     * 创建WorkerId配置
     *
     * @return 工作节点配置对象
     */
    @Override
    public WorkerIdConfig create() {
        // 从配置获取workerId位数，默认6位（最多64个节点）
        long workerIdBit = JaProperty.getLong("athena.snowflake.workerIdBit", 6L);
        // 如果程序还未启动完成就有业务调用雪花算法进行捕获异常
        if (null == workerId) {
            throw new SnowflakeInitException("雪花算法还未进行初始化");
        }
        return WorkerIdConfig.builder()
                .workerId(workerId)
                .workerIdBit(workerIdBit)
                .build();
    }

    /**
     * 设置工作节点ID
     *
     * @param workerId 要设置的工作节点ID
     */
    public void setWorkerId(Integer workerId) {
        this.workerId = workerId;
    }
}
