/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.snowflake.utils;

import com.digiwin.athena.framework.snowflake.enums.DefaultBizKey;
import com.digiwin.athena.framework.snowflake.enums.SnowflakeBizKey;
import com.digiwin.athena.framework.snowflake.handler.AthenaWorkerIdHandler;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.JaSnowflakeId;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.JaSnowflakeIdConfig;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.WorkerIdHandler;

public class AthenaSnowflake {
    public static JaSnowflakeId get(SnowflakeBizKey bizKey) {
        JaSnowflakeId generator = bizKey.getSnowflakeId();
        if (generator == null) {
            throw new IllegalArgumentException("\u672a\u6ce8\u518c\u7684\u4e1a\u52a1\u952e: " + bizKey);
        }
        return generator;
    }

    public static long nextId(SnowflakeBizKey bizKey) {
        return AthenaSnowflake.get(bizKey).get();
    }

    public static JaSnowflakeIdConfig create(String beginTimeStr) {
        JaSnowflakeIdConfig config = new JaSnowflakeIdConfig();
        config.setBeginTimeStr(beginTimeStr);
        config.setSequenceNumberBit(6L);
        config.setTimeUnit(1L);
        return config;
    }

    public static JaSnowflakeIdConfig createDefaultA() {
        JaSnowflakeIdConfig config = new JaSnowflakeIdConfig();
        config.setBeginTimeStr("2020-12-20 20:20:20");
        config.setSequenceNumberBit(6L);
        config.setTimeUnit(1L);
        return config;
    }

    public static JaSnowflakeIdConfig createDefaultB() {
        JaSnowflakeIdConfig config = new JaSnowflakeIdConfig();
        config.setBeginTimeStr("2018-12-16 21:08:16");
        config.setSequenceNumberBit(6L);
        config.setTimeUnit(1L);
        return config;
    }

    public static JaSnowflakeId newInstance(JaSnowflakeIdConfig config) {
        return JaSnowflakeId.newInstance((JaSnowflakeIdConfig)config, (WorkerIdHandler)AthenaWorkerIdHandler.INSTANCE);
    }

    public static void main(String[] args) {
        AthenaWorkerIdHandler.INSTANCE.setWorkerId(0);
        System.out.println(AthenaSnowflake.nextId(DefaultBizKey.DEFAULT_MODULE_A));
        System.out.println(AthenaSnowflake.nextId(DefaultBizKey.DEFAULT_MODULE_B));
    }
}

