package com.digiwin.athena.framework.snowflake.enums;

import com.digiwin.athena.framework.snowflake.utils.AthenaSnowflake;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.JaSnowflakeId;

import static com.digiwin.athena.framework.snowflake.utils.AthenaSnowflake.createDefaultA;
import static com.digiwin.athena.framework.snowflake.utils.AthenaSnowflake.createDefaultB;

/**
 * 默认业务键枚举，实现SnowflakeBizKey接口
 * 为不同业务模块提供预配置的雪花算法实例
 *
 * @author wzq
 */
public enum DefaultBizKey implements SnowflakeBizKey {
    DEFAULT_MODULE_A("default_module_a", AthenaSnowflake.newInstance(createDefaultA())),
    DEFAULT_MODULE_B("default_module_b", AthenaSnowflake.newInstance(createDefaultB()));

    private final String keyName;
    private final JaSnowflakeId snowflakeId;

    /**
     * 枚举构造函数
     *
     * @param keyName     业务键名称
     * @param snowflakeId 对应的雪花算法实例
     */
    DefaultBizKey(String keyName, JaSnowflakeId snowflakeId) {
        this.keyName = keyName;
        this.snowflakeId = snowflakeId;
    }

    @Override
    public String getKeyName() {
        return keyName;
    }

    @Override
    public JaSnowflakeId getSnowflakeId() {
        return snowflakeId;
    }
}