package com.digiwin.athena.framework.snowflake.configuration;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.digiwin.athena.framework.snowflake.handler.LocalWorkerIdHandler;
import com.digiwin.athena.framework.snowflake.listener.AthenaRegistrationEventListener;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 雪花算法自动配置类
 */
@Configuration
@ConditionalOnProperty(prefix = "athena.snowflake", name = "enable", havingValue = "true")
public class AthenaSnowflakeConfiguration {

    /**
     * 注册Nacos事件监听器
     *
     * @param discoveryProperties Nacos发现属性
     * @param nacosServiceManager Nacos服务管理器
     * @return 事件监听器实例
     */
    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnBean(type = {
            "com.alibaba.cloud.nacos.NacosDiscoveryProperties",
            "com.alibaba.cloud.nacos.NacosServiceManager"
    })
    public AthenaRegistrationEventListener athenaRegistrationEventListener(NacosDiscoveryProperties discoveryProperties, NacosServiceManager nacosServiceManager) {
        return new AthenaRegistrationEventListener(discoveryProperties, nacosServiceManager);
    }

    /**
     * 本地WorkerId提供者（备用方案）
     *
     * 当Nacos不可用时，使用固定WorkerId
     */
    @Bean
    @ConditionalOnMissingBean(AthenaRegistrationEventListener.class)
    @ConditionalOnProperty(prefix = "athena.snowflake.local", name = "enable", havingValue = "true")
    public LocalWorkerIdHandler localWorkerIdHandler() {
        return new LocalWorkerIdHandler();
    }

}