package com.digiwin.athena.framework.snowflake.handler;

import com.jugg.agile.framework.core.config.JaProperty;
import lombok.extern.slf4j.Slf4j;

import javax.annotation.PostConstruct;

/**
 * 本地WorkerId提供者实现
 */
@Slf4j
public class LocalWorkerIdHandler {
    @PostConstruct
    public void init() {
        Integer workerId = JaProperty.getInteger("athena.snowflake.local.worker-id", 0);
        // 本地环境使用固定workerId
        AthenaWorkerIdHandler.INSTANCE.setWorkerId(workerId);
        // 添加日志记录
        log.info("使用本地固定WorkerId: {}", workerId);
    }
}