package com.digiwin.athena.framework.snowflake;

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

/**
 * 雪花算法自动配置类
 */
@Configuration
public class AthenaWorkIdConfiguration {

    /**
     * 注册Nacos事件监听器
     *
     * @return 事件监听器实例
     */
    @Bean
    @ConditionalOnMissingBean
    public AthenaRegistrationEventListener athenaRegistrationEventListener() {
        return new AthenaRegistrationEventListener();
    }

}