/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.snowflake.listener;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.digiwin.athena.framework.snowflake.exception.InstanceNotFoundException;
import com.digiwin.athena.framework.snowflake.exception.SnowflakeInitException;
import com.digiwin.athena.framework.snowflake.exception.WorkerIdExhaustedException;
import com.digiwin.athena.framework.snowflake.handler.AthenaWorkerIdHandler;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.middleware.redis.JaRedisLock;
import com.jugg.agile.middleware.redis.meta.JaRedisLockEntity;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;

public class AthenaRegistrationEventListener {
    private static final Logger log = LoggerFactory.getLogger(AthenaRegistrationEventListener.class);
    private static final String WORKER_ID_KEY = "snowflake.worker.id";
    private static final String LOCK_KEY_PREFIX = "athena:snowflake:init:workId:%s";
    private static final int MIN_WORKER_ID = 0;
    private static final int MAX_WORKER_ID = 63;
    private static final int INVALID_WORKER_ID = -1;
    private final NacosDiscoveryProperties discoveryProperties;
    private final NacosServiceManager nacosServiceManager;

    public AthenaRegistrationEventListener(NacosDiscoveryProperties discoveryProperties, NacosServiceManager nacosServiceManager) {
        this.discoveryProperties = discoveryProperties;
        this.nacosServiceManager = nacosServiceManager;
    }

    @EventListener(value={ApplicationReadyEvent.class})
    public void onApplicationReady() {
        try {
            this.processWorkerIdAssignment();
        }
        catch (Exception e) {
            log.error("\u96ea\u82b1\u7b97\u6cd5\u5de5\u4f5c\u8282\u70b9\u5206\u914d\u5931\u8d25", (Throwable)e);
            throw new SnowflakeInitException("\u96ea\u82b1\u7b97\u6cd5\u521d\u59cb\u5316\u5931\u8d25", e);
        }
    }

    private void processWorkerIdAssignment() {
        NamingService namingService = this.getNamingService();
        Instance currentInstance = this.getCurrentInstance(namingService);
        if (currentInstance == null) {
            throw new InstanceNotFoundException("\u5f53\u524d\u670d\u52a1\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        }
        String lockKey = String.format(LOCK_KEY_PREFIX, JaEnvProperty.getApplicationName());
        JaRedisLock.lock((JaRedisLockEntity)JaRedisLockEntity.builder().lockKey(lockKey).build(), () -> {
            int workerId = this.assignWorkerId(namingService, currentInstance);
            AthenaWorkerIdHandler.INSTANCE.setWorkerId(workerId);
            log.info("\u96ea\u82b1\u7b97\u6cd5\u5de5\u4f5c\u8282\u70b9\u8bbe\u7f6e\u5b8c\u6210: {}", (Object)workerId);
            return null;
        });
    }

    private NamingService getNamingService() {
        return this.nacosServiceManager.getNamingService(this.discoveryProperties.getNacosProperties());
    }

    private Instance getCurrentInstance(NamingService namingService) {
        String currentIp = this.discoveryProperties.getIp();
        int currentPort = this.discoveryProperties.getPort();
        return this.getAllInstances(namingService).stream().filter(instance -> currentIp.equals(instance.getIp()) && currentPort == instance.getPort()).findFirst().orElse(null);
    }

    private int assignWorkerId(NamingService namingService, Instance instance) throws NacosException {
        int workerId = this.findAvailableWorkerId(namingService);
        this.updateInstanceMetadata(instance, workerId);
        this.registerInstance(namingService, instance);
        return workerId;
    }

    private int findAvailableWorkerId(NamingService namingService) {
        Set<Integer> usedIds = this.getUsedWorkerIds(namingService);
        return this.findNextAvailableId(usedIds).orElseThrow(() -> new WorkerIdExhaustedException("\u65e0\u53ef\u7528\u5de5\u4f5c\u8282\u70b9ID"));
    }

    private Set<Integer> getUsedWorkerIds(NamingService namingService) {
        return this.getAllInstances(namingService).stream().map(Instance::getMetadata).map(metadata -> (String)metadata.get(WORKER_ID_KEY)).map(this::safeParseInt).filter(id -> id >= 0).collect(Collectors.toSet());
    }

    private int safeParseInt(String value) {
        try {
            return value != null ? Integer.parseInt(value) : -1;
        }
        catch (NumberFormatException e) {
            log.warn("\u65e0\u6548\u7684WorkerID\u683c\u5f0f: {}", (Object)value);
            return -1;
        }
    }

    private Optional<Integer> findNextAvailableId(Set<Integer> usedIds) {
        for (int id = 63; id >= 0; --id) {
            if (usedIds.contains(id)) continue;
            log.info("\u5206\u914d\u5de5\u4f5c\u8282\u70b9ID: {}", (Object)id);
            return Optional.of(id);
        }
        return Optional.empty();
    }

    private void updateInstanceMetadata(Instance instance, int workerId) {
        instance.getMetadata().put(WORKER_ID_KEY, String.valueOf(workerId));
    }

    private void registerInstance(NamingService namingService, Instance instance) throws NacosException {
        namingService.registerInstance(this.discoveryProperties.getService(), this.discoveryProperties.getGroup(), instance);
    }

    private List<Instance> getAllInstances(NamingService namingService) {
        try {
            return namingService.getAllInstances(this.discoveryProperties.getService(), this.discoveryProperties.getGroup());
        }
        catch (NacosException e) {
            log.error("\u83b7\u53d6Nacos\u670d\u52a1\u5b9e\u4f8b\u5931\u8d25", (Throwable)e);
            return Collections.emptyList();
        }
    }
}

