/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.snowflake;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.framework.snowflake.AthenaWorkerIdAdapter;
import com.jugg.agile.framework.core.config.JaEnvProperty;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.WorkerIdConfig;
import com.jugg.agile.middleware.redis.JaRedisLock;
import com.jugg.agile.middleware.redis.meta.JaRedisLockEntity;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.event.EventListener;

public class AthenaRegistrationEventListener {
    private static final Logger log = LoggerFactory.getLogger(AthenaRegistrationEventListener.class);
    private static final String WORKER_ID_KEY = "snowflake.worker.id";
    private static final String LOCK_KEY_PATTERN = "athena:snowflake:init:workId:%s";
    private static final int MIN_WORKER_ID = 0;
    private static final int MAX_WORKER_ID = 63;
    private static final int INVALID_WORKER_ID = -1;
    private static final String ENABLE_KEY = "athena.snowflake.enable";
    private static final String WORKER_ID_BIT_KEY = "athena.snowflake.workerIdBit";
    private static final String LOCAL_WORKER_ID_KEY = "athena.snowflake.local.worker-id";
    private volatile NacosDiscoveryProperties discoveryProperties;
    private volatile NacosServiceManager nacosServiceManager;

    @EventListener(value={ApplicationReadyEvent.class})
    public void onApplicationReady() {
        if (!this.isSnowflakeEnabled()) {
            log.info("\u96ea\u82b1\u7b97\u6cd5\u672a\u542f\u7528\uff0c\u8df3\u8fc7\u521d\u59cb\u5316");
            return;
        }
        try {
            AthenaWorkerIdAdapter.INSTANCE = this::resolveWorkerIdConfig;
            log.info("\u96ea\u82b1\u7b97\u6cd5\u5de5\u4f5c\u8282\u70b9\u914d\u7f6e\u5b8c\u6210");
        }
        catch (Exception e) {
            log.error("\u96ea\u82b1\u7b97\u6cd5\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
            throw new BusinessException("\u96ea\u82b1\u7b97\u6cd5\u521d\u59cb\u5316\u5931\u8d25", (Throwable)e);
        }
    }

    private boolean isSnowflakeEnabled() {
        return JaProperty.getBoolean((String)ENABLE_KEY, (Boolean)Boolean.TRUE);
    }

    private WorkerIdConfig resolveWorkerIdConfig() {
        if (this.isLocalEnvironment()) {
            return this.createLocalWorkerConfig();
        }
        return this.createCloudWorkerConfig();
    }

    private WorkerIdConfig createLocalWorkerConfig() {
        int workerId = JaProperty.getInteger((String)LOCAL_WORKER_ID_KEY, (Integer)0);
        long workerIdBit = JaProperty.getLong((String)WORKER_ID_BIT_KEY, (Long)6L);
        log.info("\u672c\u5730\u73af\u5883\u4f7f\u7528\u56fa\u5b9a\u5de5\u4f5c\u8282\u70b9ID: {}", (Object)workerId);
        return WorkerIdConfig.builder().workerId((long)workerId).workerIdBit(workerIdBit).build();
    }

    private WorkerIdConfig createCloudWorkerConfig() {
        this.ensureDependenciesAvailable();
        NamingService namingService = this.getNamingService();
        Instance currentInstance = this.getCurrentInstance(namingService);
        if (currentInstance == null) {
            throw new BusinessException("\u5f53\u524d\u670d\u52a1\u5b9e\u4f8b\u4e0d\u5b58\u5728");
        }
        int workerId = this.assignWorkerIdWithLock(namingService, currentInstance);
        return WorkerIdConfig.builder().workerId((long)workerId).workerIdBit(JaProperty.getLong((String)WORKER_ID_BIT_KEY, (Long)6L).longValue()).build();
    }

    private int assignWorkerIdWithLock(NamingService namingService, Instance instance) {
        String lockKey = this.createDistributedLockKey();
        JaRedisLockEntity lockEntity = this.createLockEntity(lockKey);
        return (Integer)JaRedisLock.lock((JaRedisLockEntity)lockEntity, () -> {
            int workerId = this.findAvailableWorkerId(namingService);
            this.updateAndRegisterInstance(namingService, instance, workerId);
            return workerId;
        });
    }

    private int findAvailableWorkerId(NamingService namingService) {
        Set<Integer> usedIds = this.getUsedWorkerIds(namingService);
        return this.findAvailableId(usedIds).orElseThrow(() -> new BusinessException("\u65e0\u53ef\u7528\u5de5\u4f5c\u8282\u70b9ID (0-63)"));
    }

    private void updateAndRegisterInstance(NamingService namingService, Instance instance, int workerId) throws NacosException {
        instance.getMetadata().put(WORKER_ID_KEY, String.valueOf(workerId));
        namingService.registerInstance(this.getServiceName(), this.getGroupName(), instance);
        log.info("\u6ce8\u518c\u5b9e\u4f8b\u5b8c\u6210\uff0c\u5de5\u4f5c\u8282\u70b9ID: {}", (Object)workerId);
    }

    private boolean isLocalEnvironment() {
        return JaEnvProperty.isLocal();
    }

    private void ensureDependenciesAvailable() {
        if (this.discoveryProperties == null) {
            this.discoveryProperties = (NacosDiscoveryProperties)JaSpringBeanUtil.getBean(NacosDiscoveryProperties.class);
        }
        if (this.nacosServiceManager == null) {
            this.nacosServiceManager = (NacosServiceManager)JaSpringBeanUtil.getBean(NacosServiceManager.class);
        }
        if (this.discoveryProperties == null || this.nacosServiceManager == null) {
            throw new BusinessException("Nacos\u4f9d\u8d56\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
    }

    private String createDistributedLockKey() {
        return String.format(LOCK_KEY_PATTERN, JaEnvProperty.getApplicationName());
    }

    private JaRedisLockEntity createLockEntity(String lockKey) {
        return JaRedisLockEntity.builder().lockKey(lockKey).build();
    }

    private NamingService getNamingService() {
        return this.nacosServiceManager.getNamingService(this.discoveryProperties.getNacosProperties());
    }

    private String getServiceName() {
        return this.discoveryProperties.getService();
    }

    private String getGroupName() {
        return this.discoveryProperties.getGroup();
    }

    private Instance getCurrentInstance(NamingService namingService) {
        String currentIp = this.discoveryProperties.getIp();
        int currentPort = this.discoveryProperties.getPort();
        Map instanceMap = this.getAllInstances(namingService).stream().collect(Collectors.toMap(this::getInstanceKey, Function.identity(), (existing, replacement) -> existing));
        String currentKey = this.createInstanceKey(currentIp, currentPort);
        return (Instance)instanceMap.get(currentKey);
    }

    private String createInstanceKey(String ip, int port) {
        return ip + ":" + port;
    }

    private String getInstanceKey(Instance instance) {
        return instance.getIp() + ":" + instance.getPort();
    }

    private List<Instance> getAllInstances(NamingService namingService) {
        try {
            return namingService.getAllInstances(this.getServiceName(), this.getGroupName());
        }
        catch (NacosException e) {
            log.error("\u83b7\u53d6Nacos\u670d\u52a1\u5b9e\u4f8b\u5931\u8d25", (Throwable)e);
            return Collections.emptyList();
        }
    }

    private Set<Integer> getUsedWorkerIds(NamingService namingService) {
        return this.getAllInstances(namingService).stream().map(Instance::getMetadata).map(metadata -> (String)metadata.get(WORKER_ID_KEY)).map(this::safeParseWorkerId).filter(id -> id >= 0 && id <= 63).collect(Collectors.toSet());
    }

    private int safeParseWorkerId(String value) {
        if (value == null) {
            return -1;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            log.warn("\u65e0\u6548\u7684WorkerID\u683c\u5f0f: '{}'", (Object)value);
            return -1;
        }
    }

    private Optional<Integer> findAvailableId(Set<Integer> usedIds) {
        for (int id = 63; id >= 0; --id) {
            if (usedIds.contains(id)) continue;
            log.info("\u5206\u914d\u5de5\u4f5c\u8282\u70b9ID: {}", (Object)id);
            return Optional.of(id);
        }
        return Optional.empty();
    }
}

