/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.snowflake.example;

import com.digiwin.athena.framework.snowflake.example.AthenaSnowflake;
import com.digiwin.athena.framework.snowflake.example.SnowflakeBizKey;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.JaSnowflakeId;
import java.util.Arrays;
import java.util.Optional;

public enum DefaultSnowflakeId implements SnowflakeBizKey
{
    DEFAULT_MODULE_A("default_module_a", AthenaSnowflake.newInstance(AthenaSnowflake.createDefaultA())),
    DEFAULT_MODULE_B("default_module_b", AthenaSnowflake.newInstance(AthenaSnowflake.createDefaultB()));

    private final String keyName;
    private final JaSnowflakeId snowflakeId;

    private DefaultSnowflakeId(String keyName, JaSnowflakeId snowflakeId) {
        this.keyName = keyName;
        this.snowflakeId = snowflakeId;
    }

    @Override
    public String getKeyName() {
        return this.keyName;
    }

    @Override
    public JaSnowflakeId getSnowflakeId() {
        return this.snowflakeId;
    }

    public static Optional<JaSnowflakeId> findByKeyName(String keyName) {
        return Arrays.stream(DefaultSnowflakeId.values()).filter(e -> e.getKeyName().equals(keyName)).findFirst().map(DefaultSnowflakeId::getSnowflakeId);
    }

    public static JaSnowflakeId findByKeyNameOrDefault(String keyName) {
        return DefaultSnowflakeId.findByKeyName(keyName).orElse(AthenaSnowflake.newInstanceA());
    }

    public static Long nextId(String keyName) {
        return DefaultSnowflakeId.findByKeyNameOrDefault(keyName).get();
    }

    public static Long nextId(SnowflakeBizKey bizKey) {
        return DefaultSnowflakeId.findByEnumDefault(bizKey).get();
    }

    public static JaSnowflakeId findByEnumDefault(SnowflakeBizKey bizKey) {
        return DefaultSnowflakeId.findEnum(bizKey).orElse(AthenaSnowflake.newInstanceA());
    }

    public static Optional<JaSnowflakeId> findEnum(SnowflakeBizKey bizKey) {
        return Arrays.stream(DefaultSnowflakeId.values()).filter(e -> e.getKeyName().equals(bizKey.getKeyName())).findFirst().map(DefaultSnowflakeId::getSnowflakeId);
    }
}

