package com.digiwin.athena.framework.snowflake.example;

import com.digiwin.athena.framework.snowflake.AthenaWorkerIdAdapter;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.WorkerIdConfig;

/**
 * 使用举例
 *
 * @author wzq
 */
public class Test {

    // ===================== 使用示例 =====================
    public static void main(String[] args) {
        //第一种枚举用法
        // 设置工作节点ID（实际由监听器自动设置）
        AthenaWorkerIdAdapter.INSTANCE = () -> WorkerIdConfig.builder()
                .workerId(0)
                .workerIdBit(6L)
                .build();

        // 生成模块A的ID
        System.out.println(DefaultEnumSnowflakeId.nextId(DefaultEnumSnowflakeId.DEFAULT_MODULE_A));
        System.out.println(DefaultEnumSnowflakeId.nextId("default_module_a"));
        // 生成模块B的ID
        System.out.println(DefaultEnumSnowflakeId.nextId(DefaultEnumSnowflakeId.DEFAULT_MODULE_B));
        System.out.println(DefaultEnumSnowflakeId.nextId("default_module_b"));


        //第二种用法 每种业务定义一个类
        System.out.println(AppNameDefaultSnowflakeId.nextId());
    }
}
