/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.snowflake;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwSnowflakeNacosProcessor {
    private static final Logger log = LoggerFactory.getLogger(DwSnowflakeNacosProcessor.class);
    private static NacosDiscoveryProperties discoveryProperties;
    private static NacosServiceManager nacosServiceManager;

    public static void checkRegistered() {
        if (discoveryProperties == null) {
            discoveryProperties = (NacosDiscoveryProperties)JaSpringBeanUtil.getBean(NacosDiscoveryProperties.class);
        }
        if (nacosServiceManager == null) {
            nacosServiceManager = (NacosServiceManager)JaSpringBeanUtil.getBean(NacosServiceManager.class);
        }
        if (discoveryProperties == null || nacosServiceManager == null) {
            throw new BusinessException("Nacos\u4f9d\u8d56\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
    }

    public static NamingService getNamingService() {
        return nacosServiceManager.getNamingService(discoveryProperties.getNacosProperties());
    }

    public static String getServiceName() {
        return discoveryProperties.getService();
    }

    public static String getGroupName() {
        return discoveryProperties.getGroup();
    }

    public static Instance getCurrentInstance(NamingService namingService) {
        String currentIp = discoveryProperties.getIp();
        int currentPort = discoveryProperties.getPort();
        log.info("currentIp:{},currentPort:{}", (Object)currentIp, (Object)currentPort);
        List<Instance> allInstances = DwSnowflakeNacosProcessor.getAllInstances(namingService);
        log.info("allInstances:{}", (Object)JSON.toJSONString(allInstances));
        Map instanceMap = allInstances.stream().collect(Collectors.toMap(DwSnowflakeNacosProcessor::getInstanceKey, Function.identity(), (existing, replacement) -> existing));
        String currentKey = DwSnowflakeNacosProcessor.createInstanceKey(currentIp, currentPort);
        return (Instance)instanceMap.get(currentKey);
    }

    public static List<Instance> getAllInstances(NamingService namingService) {
        try {
            return namingService.getAllInstances(DwSnowflakeNacosProcessor.getServiceName(), DwSnowflakeNacosProcessor.getGroupName());
        }
        catch (NacosException e) {
            JaLog.error((String)"\u83b7\u53d6Nacos\u670d\u52a1\u5b9e\u4f8b\u5931\u8d25", (Object[])new Object[]{e});
            return Collections.emptyList();
        }
    }

    public static String createInstanceKey(String ip, int port) {
        return ip + ":" + port;
    }

    public static String getInstanceKey(Instance instance) {
        return instance.getIp() + ":" + instance.getPort();
    }
}

