package com.digiwin.athena.framework.snowflake;

import com.jugg.agile.framework.core.util.algorithm.id.snowflake.JaSnowflakeIdConfig;

/**
 * 雪花算法入口类
 * 提供全局访问点获取不同业务的ID生成器
 *
 * @author wzq
 */
public class DwSnowflakeIdConfigUtil {

    /**
     * 创建自定义起始时间的配置
     *
     * @param beginTimeStr 起始时间字符串（格式：yyyy-MM-dd HH:mm:ss）
     */
    public static JaSnowflakeIdConfig create(String beginTimeStr) {
        JaSnowflakeIdConfig config = new JaSnowflakeIdConfig();
        config.setBeginTimeStr(beginTimeStr);
        config.setSequenceNumberBit(6);
        config.setTimeUnit(1);
        return config;
    }

    /**
     * 创建模块A的默认配置（适合ptm系统）
     * 起始时间：2020-12-20 20:20:20
     */
    public static JaSnowflakeIdConfig createDefaultA() {
        return create("2020-12-20 20:20:20");
    }

    /**
     * 创建模块B的默认配置（适合小ai atmc等系统）
     * 起始时间：2018-12-16 21:08:16
     */
    public static JaSnowflakeIdConfig createDefaultB() {
        return create("2018-12-16 21:08:16");
    }
}