/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.snowflake;

import com.alibaba.cloud.nacos.NacosDiscoveryProperties;
import com.alibaba.cloud.nacos.NacosServiceManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.listener.EventListener;
import com.alibaba.nacos.api.naming.listener.NamingEvent;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.jugg.agile.framework.core.dapper.log.JaLog;
import com.jugg.agile.spring.util.JaSpringBeanUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwSnowflakeNacosProcessor {
    private static final Logger log = LoggerFactory.getLogger(DwSnowflakeNacosProcessor.class);
    private static NacosDiscoveryProperties discoveryProperties;
    private static NacosServiceManager nacosServiceManager;

    public static void checkRegistered() {
        if (discoveryProperties == null) {
            discoveryProperties = (NacosDiscoveryProperties)JaSpringBeanUtil.getBean(NacosDiscoveryProperties.class);
        }
        if (nacosServiceManager == null) {
            nacosServiceManager = (NacosServiceManager)JaSpringBeanUtil.getBean(NacosServiceManager.class);
        }
        if (discoveryProperties == null || nacosServiceManager == null) {
            throw new BusinessException("Nacos\u4f9d\u8d56\u672a\u627e\u5230\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
    }

    public static NamingService getNamingService() {
        return nacosServiceManager.getNamingService(discoveryProperties.getNacosProperties());
    }

    public static String getServiceName() {
        return discoveryProperties.getService();
    }

    public static String getGroupName() {
        return discoveryProperties.getGroup();
    }

    public static Instance getCurrentInstance(NamingService namingService) {
        String currentIp = discoveryProperties.getIp();
        int currentPort = discoveryProperties.getPort();
        log.info("currentIp:{},currentPort:{}", (Object)currentIp, (Object)currentPort);
        List<Instance> allInstances = DwSnowflakeNacosProcessor.getAllInstances(namingService);
        log.info("allInstances:{}", (Object)JSON.toJSONString(allInstances));
        Map instanceMap = allInstances.stream().collect(Collectors.toMap(DwSnowflakeNacosProcessor::getInstanceKey, Function.identity(), (existing, replacement) -> existing));
        String currentKey = DwSnowflakeNacosProcessor.createInstanceKey(currentIp, currentPort);
        return (Instance)instanceMap.get(currentKey);
    }

    public static List<Instance> getAllInstances(NamingService namingService) {
        try {
            return namingService.getAllInstances(DwSnowflakeNacosProcessor.getServiceName(), DwSnowflakeNacosProcessor.getGroupName());
        }
        catch (NacosException e) {
            JaLog.error((String)"\u83b7\u53d6Nacos\u670d\u52a1\u5b9e\u4f8b\u5931\u8d25", (Object[])new Object[]{e});
            return Collections.emptyList();
        }
    }

    public static String createInstanceKey(String ip, int port) {
        return ip + ":" + port;
    }

    public static String getInstanceKey(Instance instance) {
        return instance.getIp() + ":" + instance.getPort();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Instance> getAllInstancesWithSubscribe(NamingService namingService) {
        AtomicReference resultRef = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        long timeout = 30L;
        EventListener listener = event -> {
            NamingEvent namingEvent;
            List instances;
            if (event instanceof NamingEvent && !(instances = (namingEvent = (NamingEvent)event).getInstances()).isEmpty()) {
                resultRef.set(instances);
                latch.countDown();
            }
        };
        try {
            namingService.subscribe(DwSnowflakeNacosProcessor.getServiceName(), DwSnowflakeNacosProcessor.getGroupName(), listener);
        }
        catch (NacosException e) {
            log.error("Nacos\u8ba2\u9605\u670d\u52a1\u5931\u8d25\uff0c\u670d\u52a1\u540d: {}, \u5206\u7ec4: {}", new Object[]{DwSnowflakeNacosProcessor.getServiceName(), DwSnowflakeNacosProcessor.getGroupName(), e});
            throw new BusinessException("Nacos\u8ba2\u9605\u670d\u52a1\u5931\u8d25", (Throwable)e);
        }
        try {
            if (!latch.await(30L, TimeUnit.SECONDS)) {
                log.warn("\u7b49\u5f85Nacos\u670d\u52a1\u5b9e\u4f8b\u901a\u77e5\u8d85\u65f6\uff0c\u5c06\u5c1d\u8bd5\u76f4\u63a5\u83b7\u53d6\u5b9e\u4f8b");
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("\u7b49\u5f85Nacos\u670d\u52a1\u5b9e\u4f8b\u901a\u77e5\u88ab\u4e2d\u65ad");
        }
        finally {
            try {
                namingService.unsubscribe(DwSnowflakeNacosProcessor.getServiceName(), DwSnowflakeNacosProcessor.getGroupName(), listener);
            }
            catch (NacosException e) {
                log.warn("\u53d6\u6d88Nacos\u8ba2\u9605\u5931\u8d25", (Throwable)e);
            }
        }
        List instances = (List)resultRef.get();
        if (instances != null && !instances.isEmpty()) {
            return instances;
        }
        try {
            return namingService.getAllInstances(DwSnowflakeNacosProcessor.getServiceName(), DwSnowflakeNacosProcessor.getGroupName());
        }
        catch (NacosException e) {
            log.error("\u83b7\u53d6Nacos\u670d\u52a1\u5b9e\u4f8b\u5931\u8d25", (Throwable)e);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Instance getCurrentInstanceWithRetry(NamingService namingService) {
        int retryCount = 0;
        int maxCount = 5;
        int timeOut = 2000;
        while (retryCount < maxCount) {
            try {
                Instance instance = DwSnowflakeNacosProcessor.getCurrentInstance(namingService);
                if (instance != null) {
                    Instance instance2 = instance;
                    return instance2;
                }
                Thread.sleep(timeOut);
            }
            catch (Exception e) {
                log.error("\u83b7\u53d6Nacos\u670d\u52a1\u5b9e\u4f8b\u5931\u8d25\uff0c\u91cd\u8bd5\u6b21\u6570: {}", (Object)retryCount, (Object)e);
                try {
                    Thread.sleep(timeOut);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            }
            finally {
                ++retryCount;
            }
        }
        return null;
    }
}

