/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.snowflake;

import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.JaSnowflakeIdConfig;
import com.jugg.agile.framework.core.util.algorithm.id.snowflake.WorkerIdConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DwSnowflakeIdConfigUtil {
    private static final Logger log = LoggerFactory.getLogger(DwSnowflakeIdConfigUtil.class);

    public static JaSnowflakeIdConfig create(String beginTimeStr) {
        JaSnowflakeIdConfig config = new JaSnowflakeIdConfig();
        config.setBeginTimeStr(beginTimeStr);
        config.setSequenceNumberBit(6L);
        config.setTimeUnit(1L);
        return config;
    }

    public static JaSnowflakeIdConfig createDefaultA() {
        return DwSnowflakeIdConfigUtil.create("2020-12-20 20:20:20");
    }

    public static JaSnowflakeIdConfig createDefaultB() {
        return DwSnowflakeIdConfigUtil.create("2018-12-16 21:08:16");
    }

    public static WorkerIdConfig createLocalWorkerConfig() {
        int workerId = JaProperty.getInteger((String)"athena.snowflake.local.worker-id", (Integer)63);
        long workerIdBit = JaProperty.getLong((String)"athena.snowflake.workerIdBit", (Long)6L);
        log.info("\u672c\u5730\u73af\u5883\u4f7f\u7528\u56fa\u5b9a\u5de5\u4f5c\u8282\u70b9ID: {}", (Object)workerId);
        return WorkerIdConfig.builder().workerId((long)workerId).workerIdBit(workerIdBit).build();
    }
}

