package com.digiwin.athena.framework.test.autoconfigure;

import com.digiwin.athena.framework.test.listener.BeforeAllTestExecutionListener;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.test.context.TestExecutionListeners;

@Target(ElementType.TYPE)
@Retention(RetentionPolicy.RUNTIME)
@Documented
@Inherited
@SpringBootTest
@TestExecutionListeners(
    listeners = BeforeAllTestExecutionListener.class, // 注册你的自定义监听器
    mergeMode = TestExecutionListeners.MergeMode.MERGE_WITH_DEFAULTS // 与 Spring 默认监听器合并
)
@AutoConfigureMockMvc
public @interface AthenaBootTest {

  SpringBootTest.WebEnvironment webEnvironment() default SpringBootTest.WebEnvironment.RANDOM_PORT;

  /**
   * spring.application.name
   *
   * @return
   */
  String appName() default "";

  /***
   * 版本号
   * @return
   */
  String version() default "2.2.30";

  /**
   * 默认paas环境
   *
   * @return
   */
  String env() default "aliyun-paas";
}
