package com.digiwin.athena.framework.test.enums;

import java.util.Arrays;

public enum EnvType {

  PASS("PASS", "aliyun-paas", "阿里paas区"),
  ;
  private final String name;    // 枚举名 (如 "PASS")
  private final String code;    // 环境标识 (如 "aliyun-paas")
  private final String description; // 环境描述

  private EnvType(String name, String code, String description) {
    this.name = name;
    this.code = code;
    this.description = description;
  }

  public static EnvType getEnvType(String code) {
    EnvType[] values = values();
    return Arrays.stream(values).filter(envType -> envType.getCode().equals(code)).findFirst()
        .orElse(null);
  }

  public String getCode() {
    return code;
  }
}
