package com.digiwin.athena.framework.test.utils;

import com.digiwin.athena.framework.test.autoconfigure.AthenaBootTest;
import com.digiwin.athena.framework.test.enums.EnvType;
import com.digiwin.athena.framework.test.handler.InitParamHandler;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.util.ObjectUtils;

/**
 * Alor 2025/9/28
 **/
public class InitParamHandlerUtil {

  public static <T extends InitParamHandler> void loadInitParamHandler(Class<T> aClass,
      AthenaBootTest athenaBootTest) {
    ServiceLoader<T> serviceLoader = ServiceLoader.load(aClass);
    List<T> initParamHandlers = StreamSupport.stream(
            serviceLoader.spliterator(), false)
        .filter(handler -> EnvType.getEnvType(athenaBootTest.env())
            .equals(handler.env())) // Lambda 表达式作为筛选条件
        .collect(Collectors.toList());
    if(!ObjectUtils.isEmpty(initParamHandlers)){
      initParamHandlers.sort(Comparator.comparing(T::order));
      initParamHandlers.forEach(initParamHandler -> initParamHandler.init(athenaBootTest));
    }
  }

}
