/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.framework.test.utils;

import com.digiwin.athena.framework.test.autoconfigure.AthenaBootTest;
import com.digiwin.athena.framework.test.enums.EnvType;
import com.digiwin.athena.framework.test.handler.InitParamHandler;
import com.jugg.agile.framework.meta.JaOrder;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.util.ObjectUtils;

public class InitParamHandlerUtil {
    public static <T extends InitParamHandler> void loadInitParamHandler(Class<T> aClass, AthenaBootTest athenaBootTest) {
        ServiceLoader<T> serviceLoader = ServiceLoader.load(aClass);
        List<InitParamHandler> initParamHandlers = StreamSupport.stream(serviceLoader.spliterator(), false).filter(handler -> EnvType.getEnvType(athenaBootTest.env()).equals(handler.env())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(initParamHandlers)) {
            initParamHandlers.sort(Comparator.comparing(JaOrder::order));
            initParamHandlers.forEach(initParamHandler -> initParamHandler.init(athenaBootTest));
        }
    }
}

