package com.digiwin.athena.framework.test.handler.support;

import com.digiwin.athena.framework.test.autoconfigure.AthenaBootTest;
import com.digiwin.athena.framework.test.autoconfigure.AthenaBootTest.Config;
import com.digiwin.athena.framework.test.enums.EnvType;
import com.digiwin.athena.framework.test.handler.InitParamHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.config.JaSystemProperty;

/**
 * Alor 2025/9/26
 **/
public class PassEnvNacosConfigParamHandler implements InitParamHandler<EnvType> {

  @Override
  public EnvType env() {
    return EnvType.PASS;
  }

  @Override
  public void init(AthenaBootTest athenaBootTest) {
    //条件写在业务方法中，后续考虑可以键入条件
    if(athenaBootTest.config().equals(Config.NACOS)){
      JaSystemProperty.setEnv(athenaBootTest.env());
      JaSystemProperty.setApplicationName(athenaBootTest.appName());
      JaSystemProperty.setVersion(athenaBootTest.version());
      //下面暂且不支持传入，后续考虑直接传入properties@TODO
      JaProperty.getPropertyMap()
          .put("ja.nacos.serverAddr", "https://nacos-paas.digiwincloud.com.cn");
      JaProperty.getPropertyMap().put("ja.nacos.username", "athena-nonfunc");
      JaProperty.getPropertyMap().put("ja.nacos.password", "athena");
      JaProperty.getPropertyMap()
          .put("ja.nacos.namespace.application", "f1271d47-fe9c-4938-abfa-2dbf2cf3c144");
      JaProperty.getPropertyMap()
          .put("ja.nacos.namespace.common", "f408c007-a82f-44df-9b2d-68a0f008bf61");
    }
  }

  @Override
  public int order() {
    return -1;
  }
}
