package com.digiwin.athena.framework.test.listener;

import com.digiwin.athena.framework.test.autoconfigure.AthenaBootTest;
import com.digiwin.athena.framework.test.handler.InitParamHandler;
import com.digiwin.athena.framework.test.utils.InitParamHandlerUtil;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;

/**
 * 自定义测试执行监听器，用于实现 @BeforeAll 的逻辑。
 */
public class BeforeAllTestExecutionListener extends AbstractTestExecutionListener {

    /**
     * 在所有测试方法执行之前，且在 Spring 上下文创建之前调用。 这与 @BeforeAll 的执行时机完全吻合。
     */
    @Override
    public void beforeTestClass(TestContext testContext) throws Exception {
        // 2. 使用反射获取测试类上的 @AthenaBootTest 注解实例
        AthenaBootTest athenaBootTest = testContext.getTestClass()
            .getAnnotation(AthenaBootTest.class);
        InitParamHandlerUtil.loadInitParamHandler(InitParamHandler.class, athenaBootTest);
    }
}