package com.digiwin.athena.abt.sdk.manager;

import com.digiwin.athena.abt.sdk.meta.dto.AbtResultDTO;
import com.digiwin.athena.abt.sdk.meta.dto.response.GetErrorTableRespDTO;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;

import java.util.HashMap;
import java.util.Map;

public class AbtManager {
    /**
     * 获取abt组件域名地址（域名配置【不要以/结尾】）
     */
    private static String getAbtUri() {
        return JaProperty.get("abt.uri");
    }

    private static final ParameterizedTypeReference<AbtResultDTO<GetErrorTableRespDTO>> ErrorTableType = new ParameterizedTypeReference<AbtResultDTO<GetErrorTableRespDTO>>() {
    };

    /**
     * 获取导入失败列表
     */
    public static final String GET_ERROR_TABLE = getAbtUri() + "/baseDataEntry/getErrorTable/{masterId}";

    public static AbtResultDTO<GetErrorTableRespDTO> getErrorTable(String masterId) {
        Map<String, Object> param = new HashMap<>();
        param.put("masterId", masterId);
        return DwSpringHttpUtil.get(GET_ERROR_TABLE, ErrorTableType, param);
    }
}
