package com.digiwin.athena.aim.sdk.manager;

import com.digiwin.athena.aim.sdk.meta.dto.AimResultDTO;
import com.digiwin.athena.aim.sdk.meta.dto.request.AppMessageReqDTO;
import com.digiwin.athena.aim.sdk.meta.dto.request.message.MessageBatchUserDTO;
import com.digiwin.athena.aim.sdk.meta.dto.request.message.MessageDTO;
import com.digiwin.athena.aim.sdk.meta.dto.response.GrayTenantDTO;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.common.sdk.manager.meta.constants.DwHttpHeaderConstants;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * aim 相关接口
 *
 * @author gengwei
 * @since 2024/9/2 16:52
 */
public class AimManager {

    private static String getAimUri() {
        return JaProperty.get("aim.uri");
    }

    private static final ParameterizedTypeReference<AimResultDTO<Object>> ObjectType = new ParameterizedTypeReference<AimResultDTO<Object>>() {
    };

    private static final ParameterizedTypeReference<AimResultDTO<List<String>>> WithPreTenantDTOType = new ParameterizedTypeReference<AimResultDTO<List<String>>>() {
    };

    private static final ParameterizedTypeReference<AimResultDTO<GrayTenantDTO>> WithResolveTenantDTOType = new ParameterizedTypeReference<AimResultDTO<GrayTenantDTO>>() {
    };


    /**
     * 存储新消息
     */
    public static final String Url_message = getAimUri() + "/api/aim/v1/message";

    public static AimResultDTO<Object> message(AuthoredUser authoredUser, MessageDTO message) {
        return DwSpringHttpUtil.post(Url_message, message, ObjectType, headers -> headers.add(DwHttpHeaderConstants.Header_User_Token, authoredUser.getToken()));
    }


    /**
     * 发送消息提醒
     */
    public static final String Url_sendMsgRemindToClient = getAimUri() + "/api/aim/v2/send/message/remind/to/client";

    public static AimResultDTO<Object> sendMsgRemindToClient(String token, AppMessageReqDTO appMessageDTO) {
        return DwSpringHttpUtil.post(Url_sendMsgRemindToClient, appMessageDTO, ObjectType, headers -> headers.add(DwHttpHeaderConstants.Header_User_Token, token));

    }

    /**
     * 发送消息给在线客户端
     */
    public static final String Url_sendMessageToClient = getAimUri() + "/api/aim/v2/send/message/to/client";

    public static AimResultDTO<Object> sendMessageToClient(String token, MessageBatchUserDTO messageBatchUserDTO) {
        return DwSpringHttpUtil.post(Url_sendMessageToClient, messageBatchUserDTO, ObjectType, headers -> headers.add(DwHttpHeaderConstants.Header_User_Token, token));

    }

    public static final String PRE_ENV_TENANTLDLIST_URL = getAimUri() + "/api/aim/v1/tenant/route/queryPreEnvTenantIdList";

    public static final String PRE_ENV_RESOLVE_TENANTLDLIST_URL = getAimUri() + "/api/aim/v1/tenant/route/queryResolveEnvTenantIdList";

    /**
     * 查询预发布环境的租户ld列表
     *
     * @param appCode
     * @return
     */
    public static AimResultDTO<List<String>> queryPreEnvTenantldList(String appCode) {
        String url = UriComponentsBuilder.fromHttpUrl(PRE_ENV_TENANTLDLIST_URL).queryParam("app", appCode).build().encode().toUriString();
        return DwSpringHttpUtil.get(url, WithPreTenantDTOType, httpHeaders -> {
            String tenantIds = JaProperty.get("athena.export.grayTenants");
            tenantIds = JaStringUtil.isEmpty(tenantIds) ? "99990000" : tenantIds;
            String[] tenantIdArray = StringUtils.split(tenantIds, ",");
            String tenantId = (tenantIdArray != null && tenantIdArray.length > 0) ? tenantIdArray[0] : "99990000";
            httpHeaders.set(DwHttpHeaderConstants.Header_RoutingKey, tenantId);
            httpHeaders.set(DwHttpHeaderConstants.Header_Token, "e6cf01a1-18b1-45e4-ba2b-6ccdb35c49b9");
        }, Collections.emptyMap());
    }

    /**
     * 查询预发布环境的租户ld列表<br></>
     * 新接口：如果是生产环境，则返回所有的租户，如果不是，则返回当前环境的租户
     *
     * @param appCode
     * @return
     */
    public static AimResultDTO<GrayTenantDTO> queryResolveEnvTenantIdList(String appCode, String mode) {
        String url = UriComponentsBuilder.fromHttpUrl(PRE_ENV_RESOLVE_TENANTLDLIST_URL).queryParam("app", appCode).queryParam("mode", mode).build().encode().toUriString();
        return DwSpringHttpUtil.get(url, WithResolveTenantDTOType, httpHeaders -> {
//            String tenantIds = JaProperty.get("athena.export.grayTenants");
//            tenantIds = JaStringUtil.isEmpty(tenantIds) ? "99990000" : tenantIds;
//            String[] tenantIdArray = StringUtils.split(tenantIds, ",");
//            String tenantId = (tenantIdArray != null && tenantIdArray.length > 0) ? tenantIdArray[0] : "99990000";
//            httpHeaders.set(DwHttpHeaderConstants.Header_RoutingKey, tenantId);
            httpHeaders.set(DwHttpHeaderConstants.Header_Token, "e6cf01a1-18b1-45e4-ba2b-6ccdb35c49b9");
        }, Collections.emptyMap());
    }
}
