package com.digiwin.athena.atdm.sdk.manager;

import com.digiwin.athena.atdm.sdk.meta.dto.AtdmResultDTO;
import com.digiwin.athena.atdm.sdk.meta.dto.request.action.QueryBacklogWithMetadataReqDTO;
import com.digiwin.athena.atdm.sdk.meta.dto.request.action.SubmitActionReqDTO;
import com.digiwin.athena.atdm.sdk.meta.dto.response.ExecuteResultRespDTO;
import com.digiwin.athena.atdm.sdk.meta.dto.response.GetErrorTableRespDTO;
import com.digiwin.athena.atdm.sdk.meta.dto.response.QueryResultSetRespDTO;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * atdm 相关接口
 *
 * @author gengwei
 * @since 2024/9/2 17:45
 */
public class AtdmManager {

    private static String getAtdmUri() {
        return JaProperty.get("atdm.uri");
    }

    private static final ParameterizedTypeReference<AtdmResultDTO<ExecuteResultRespDTO>> ExecuteResultType = new ParameterizedTypeReference<AtdmResultDTO<ExecuteResultRespDTO>>() {
    };
    private static final ParameterizedTypeReference<AtdmResultDTO<List<Map<Object, Object>>>> ListMapType = new ParameterizedTypeReference<AtdmResultDTO<List<Map<Object, Object>>>>() {
    };
    private static final ParameterizedTypeReference<AtdmResultDTO<Map<Object, Object>>> MapType = new ParameterizedTypeReference<AtdmResultDTO<Map<Object, Object>>>() {
    };
    private static final ParameterizedTypeReference<AtdmResultDTO<Object>> ObjectType = new ParameterizedTypeReference<AtdmResultDTO<Object>>() {
    };
    private static final ParameterizedTypeReference<AtdmResultDTO<QueryResultSetRespDTO>> QueryResultSetType = new ParameterizedTypeReference<AtdmResultDTO<QueryResultSetRespDTO>>() {
    };

    private static final ParameterizedTypeReference<AtdmResultDTO<GetErrorTableRespDTO>> ErrorTableType = new ParameterizedTypeReference<AtdmResultDTO<GetErrorTableRespDTO>>() {
    };


    /**
     * 执行
     */
    public static final String ACTION_EXECUTE_URL = getAtdmUri() + "api/atdm/v1/action/execute";


    /**
     * 执行
     */
    public static AtdmResultDTO<ExecuteResultRespDTO> executeTask(SubmitActionReqDTO submitAction) {
        return DwSpringHttpUtil.post(ACTION_EXECUTE_URL, submitAction, ExecuteResultType);
    }

    /**
     * 提交合并的任务
     */
    public static final String ACTION_SUBMIT_MERGE_TASK_URL = getAtdmUri() + "api/atdm/v1/action/submit/mergeTask";

    /**
     * 提交合并的任务
     */
    public static AtdmResultDTO<List<Map<Object, Object>>> submitMergeTask(List<SubmitActionReqDTO> mergeActionList) {
        return DwSpringHttpUtil.post(ACTION_SUBMIT_MERGE_TASK_URL, mergeActionList, ListMapType);
    }


    /**
     * 提交
     */
    public static final String ACTION_SUBMIT_TASK_URL = getAtdmUri() + "api/atdm/v1/action/submit/task";


    /**
     * 提交
     */
    public static AtdmResultDTO<Map<Object, Object>> submitTask(SubmitActionReqDTO submitAction) {
        return DwSpringHttpUtil.post(ACTION_SUBMIT_TASK_URL, submitAction, MapType);
    }

    /**
     * 清除缓存
     */
    public static final String CACHE_RESET_URL = "api/atdm/v1/cache/reset?size={size}";

    /**
     * 清除缓存
     */
    public static void clearCache(Integer size) {
        Map<String, Object> param = new HashMap<>();
        param.put("size", size);
        DwSpringHttpUtil.get(CACHE_RESET_URL, ObjectType, param);
    }

    /**
     * 根据数据源获取应用业务数据
     */
    public static final String WITH_META_DATA_URL = getAtdmUri() + "api/atdm/v1/data/query/by/backlog/withmetadata";


    public static AtdmResultDTO<QueryResultSetRespDTO> queryBacklogWithMetadata(QueryBacklogWithMetadataReqDTO queryBacklogWithMetadataReqDTO) {
        return DwSpringHttpUtil.post(WITH_META_DATA_URL, queryBacklogWithMetadataReqDTO, QueryResultSetType);
    }

    /**
     * 获取导入失败列表
     */
    public static final String GET_ERROR_TABLE = getAtdmUri() + "baseDataEntry/getErrorTable/{masterId}";

    public static AtdmResultDTO<GetErrorTableRespDTO> getErrorTable(String masterId) {
        Map<String, Object> param = new HashMap<>();
        param.put("masterId", masterId);
        return DwSpringHttpUtil.get(GET_ERROR_TABLE, ErrorTableType, param);
    }
}
