package com.digiwin.athena.atdm.sdk.meta.dto.request.action;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.io.Serializable;
import java.util.Map;

/**
 * 前端执行的Action实体
 * 例如执行保存、更新、删除等action
 */
@Setter
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class SubmitActionReqDTO implements Serializable {

    private static final long serialVersionUID = -1223707892098559505L;
    /**
     * 主ACTION
     */
    private SubmitActionDTO action;

    /**
     * Action的数据
     */
    private Map<String, Object> data;

    /**
     * 补充信息，用于scs后端分页查询校验处理
     */
    private AdditionalInfoReqDTO additionalInfo;

    /**
     * 实际操作的用户
     */
    private AuthoredUser operateAuthoredUser;

    /**
     * activityCode
     */
    private String activityCode;
}
