package com.digiwin.athena.atdm.sdk.meta.dto.response;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;

import java.io.Serializable;
import java.util.Map;


/**
 * 每个数据源的查询结果，主要用来存储数据名，数据，元数据，数据索引
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class ExecuteResultRespDTO implements Serializable {
    /**
     * 任务引擎和流程引擎代表true表示任务已完成，atmc通过这个字段为true进行关卡
     */
    private boolean completed;
    private String msg;
    /**
     * 是否异步
     */
    private boolean async;

    private Map<String, Object> requestData;

    /**
     * 附加返回数据
     */
    private Map<String, Object> extendResult;

    /**
     * 数据结果集合
     */
    private Map<String, Object> data;

    /**
     * 是否真正执行完
     */
    private Boolean executeState = Boolean.TRUE;


    public static ExecuteResultRespDTO ok() {
        ExecuteResultRespDTO queryResult = new ExecuteResultRespDTO();
        queryResult.setCompleted(true);
        return queryResult;
    }


}
