package com.digiwin.athena.atmc.sdk.meta.dto.response;

import com.digiwin.athena.atmc.sdk.meta.enums.MilestoneState;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;

import java.util.List;

@Builder
@AllArgsConstructor
@NoArgsConstructor
@Getter
@Setter
public class RouteItemRespDTO {
    /**
     * 关卡id
     */
    private String id;
    /**
     * 关卡名称
     */
    private String name;
    /**
     * 关卡路线
     */
    private String pass;
    /**
     * invokeProject:发起新项目
     */
    private String type;
    /**
     * 关卡里面包含的任务
     */
    List<TaskPanelActivityRespDTO> taskCodes;

    private MilestoneState milestoneState;

    /**
     * 页面是否可点击
     */
    private Boolean clickable;

    /**
     * 页面上是否禁用
     */
    private Boolean disabled;

    /**
     * 打开页面，首次定位的节点
     */
    private Boolean init;

}
