package com.digiwin.athena.atmc.sdk.manager;

import com.digiwin.athena.atmc.sdk.meta.dto.AtmcResultDTO;
import com.digiwin.athena.atmc.sdk.meta.dto.request.PanelInfoReqDTO;
import com.digiwin.athena.atmc.sdk.meta.dto.request.SubProjectReqDTO;
import com.digiwin.athena.atmc.sdk.meta.dto.response.SubProjectRespDTO;
import com.digiwin.athena.atmc.sdk.meta.dto.response.TaskDataSourcesRespDTO;
import com.digiwin.athena.atmc.sdk.meta.dto.response.TaskPanelV2RespDTO;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @author 杨尹(22191)
 * @version v1.0
 * @since 2024/9/23 16:09
 */
public class AtmcManager {

    private static String getPrefixUri() {
        return JaProperty.get("atmc.uri");
    }

    private static final ParameterizedTypeReference<AtmcResultDTO<TaskPanelV2RespDTO>> PanelInfoResultType =
            new ParameterizedTypeReference<AtmcResultDTO<TaskPanelV2RespDTO>>() {
            };

    private static final ParameterizedTypeReference<AtmcResultDTO<TaskDataSourcesRespDTO>> GetSourcesByMainTaskIdV2ResultType =
            new ParameterizedTypeReference<AtmcResultDTO<TaskDataSourcesRespDTO>>() {
            };

    private static final ParameterizedTypeReference<AtmcResultDTO<List<SubProjectRespDTO>>> GetSubProjectResultType =
            new ParameterizedTypeReference<AtmcResultDTO<List<SubProjectRespDTO>>>() {
            };

    /**
     * 任务引擎面板信息
     */
    public static final String ATMC_GET_PANELINFO = getPrefixUri() + "/api/atmc/v1/task/panel/taskEnginePanelInfo";


    /**
     * 获取任务引擎面板信息
     */
    public static AtmcResultDTO<TaskPanelV2RespDTO> panelInfo(PanelInfoReqDTO requestDTO) {

        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.fromHttpUrl(ATMC_GET_PANELINFO)
                .queryParam("taskId", requestDTO.getTaskId()).queryParam("reqPtm",true);
        if (!StringUtils.isEmpty(requestDTO.getShareCode())) {
            uriComponentsBuilder.queryParam("shareCode", requestDTO.getShareCode());
        }
        if (requestDTO.isShare()) {
            uriComponentsBuilder.queryParam("isShare", true);
        }

        return DwSpringHttpUtil.get(uriComponentsBuilder.build().toUriString(), PanelInfoResultType);
    }


    /**
     * 数据来源
     */
    public static final String ATMC_GET_TASK_SOURCES = getPrefixUri() + "/api/atmc/v2/task/panel/getSourcesByMainTaskId";

    /**
     * 获取数据来源
     */
    public static AtmcResultDTO<TaskDataSourcesRespDTO> getSourcesByMainTaskIdV2(SubProjectReqDTO subProjectReqDTO) {
        return DwSpringHttpUtil.post(ATMC_GET_TASK_SOURCES, subProjectReqDTO, GetSourcesByMainTaskIdV2ResultType);
    }

    /**
     * 获取子项目
     */
    public static final String ATMC_GET_SUBPROJECT = getPrefixUri() + "/api/atmc/v2/project/subproject";

    /**
     * 获取子项目
     */
    public static AtmcResultDTO<List<SubProjectRespDTO>> getSubProject(SubProjectReqDTO requestDTO) {
        return DwSpringHttpUtil.post(ATMC_GET_SUBPROJECT, requestDTO, GetSubProjectResultType);
    }


}
