package com.digiwin.athena.cac.sdk.meta.dto;

import com.jugg.agile.framework.meta.handler.JaResultParseHandler;
import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.experimental.SuperBuilder;
import org.springframework.http.HttpStatus;

/**
 * cac 返回的数据格式
 *
 * @author gengwei
 * @since 2024/8/15 09:28
 */
@Setter
@Getter
@SuperBuilder
@AllArgsConstructor
@NoArgsConstructor
public class CacResultDTO<T> implements JaResultParseHandler<T> {

    private Integer code;
    private String message;
    private Boolean success;

    private T data;

    @Override
    public Boolean success() {
        if (null == code || null == success) {
            return false;
        }
        return HttpStatus.OK.equals(HttpStatus.resolve(code)) && Boolean.TRUE.equals(success);
    }

    @Override
    public String code() {
        return String.valueOf(code);
    }

    @Override
    public String message() {
        return getMessage();
    }

    @Override
    public T data() {
        return getData();
    }
}
