package com.digiwin.athena.datamap.sdk.meta.dto.response;

import lombok.Data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Data
public class TmStartProjectDTO {
    /**
     * 访问权限表示，allow：允许访问；forbidden：禁止访问
     */
    private String effect;

    /**
     * 是否公共应用
     */
    private Boolean commonApp;

    /**
     * 分组名称
     */
    private String groupName;

    /**
     * 分组编码
     */
    private String groupCode;

    private String groupSort;

    private String classifyName;

    private String classifyCode;

    private TmDataStateDTO init;

    private TmDataStateDTO end;

    /**
     * 执行类型 mainline user solve
     */
    private String executeType;

    /**
     * 项目类型 BUSINESS FEEDBACK REPORT MECHANISM 需要兼容到
     */
    private String type;

    /**
     * 是否支持手动发起
     */
    private Boolean manualAble;

    /**
     * 项目下任务【task表】code集合
     */
    @Deprecated
    private List<String> mainLineTasks;

    /**
     * 鉴权前缀
     */
    private String authorityPrefix;

    /**
     * 执行逻辑具体配置
     */
    private Map<String, Object> config = new HashMap<>();

    private String athena_namespace;

    @Deprecated
    private String application;

    private String id;

    private String code;

    private String version;

    private String name;

    private String description;

    private String datamap;

    private String tenantId;

    private String sourceId;

    private Integer sourceLevel;
}
