package com.digiwin.athena.emc.sdk.manager;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.common.sdk.manager.util.DwSpringHttpUtil;
import com.digiwin.athena.emc.sdk.dto.EmcResultDTO;
import com.jugg.agile.framework.core.config.JaProperty;
import org.springframework.core.ParameterizedTypeReference;

import java.util.Map;

/**
 * emc 相关接口
 *
 * @author gengwei
 * @since 2024/8/15 11:18
 */
public class EmcManager {

    private static String getEmcUri() {
        return JaProperty.get("emc.uri");
    }

    private static final ParameterizedTypeReference<EmcResultDTO<Map<Object, Object>>> MapType = new ParameterizedTypeReference<EmcResultDTO<Map<Object, Object>>>() {
    };


    /**
     * 发送模板邮件
     */
    public static final String SEND_EMAIL_URL = getEmcUri() + "/api/emc/v1/message/email";

    public static EmcResultDTO<Map<Object, Object>> sendEmail(JSONObject content) {
        return DwSpringHttpUtil.post(SEND_EMAIL_URL, content, MapType);

    }


}
