package com.digiwin.athena.eoc.sdk.meta.constants;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 全局常量
 */
public final class EocConstant {

    public static final String IAM_USER_TOKEN = "digi-middleware-auth-user";

    public static final String IAM_APP_TOKEN = "digi-middleware-auth-app";

    public static final String IAM_IDENTITY_TYPE_TOKEN = "token";

    public static final String LANGUAGE_CN = "zh-CN";

    public static final String AREA = "CN";

    public static final String AREA_TW = "TW";

    public static final String AUTH_USER = "digi-middleware-auth-user-data";

    /**
     * 当责者
     */
    public static final String ACTION_IDENTITY_CHARGE = "charge";
    /**
     * 执行者
     */
    public static final String ACTION_IDENTITY_PERFORMER = "performer";

    /**
     * 数据库中的空主键
     */
    public static final Long EMPTY_PRIMARY_KEY = 0L;

    /**
     * 项目卡列表-异常、逾期查询条件
     */
    public static final String PROJECT_FILTER_CATEGORY_EXCEPTION = "exception";

    /**
     * 项目卡列表-正常进行查询条件
     */
    public static final String PROJECT_FILTER_CATEGORY_REGULAR = "regular";

    /**
     * 项目卡列表-全部查询条件
     */
    public static final String PROJECT_FILTER_CATEGORY_ALL = "all";

    /**
     * 逾期任务卡的类型
     */
    public final static Integer OVERDUE_BACKLOG_TYPE = 88;

    public final static String OVERDUE_BACKLOG_NAME = "{\"zh_TW\":\"逾時處理\",\"en_US\":\"Overtime Process\",\"zh_CN\":\"逾时处理\"}";

    /**
     * 任务卡的状态-同意
     */
    public final static String BACKLOG_ACTIVITY_AGREE = "{\"zh_TW\":\"同意\",\"en_US\":\"Agree\",\"zh_CN\":\"同意\"}";

    /**
     * 任务卡的状态-转派
     */
    public final static String BACKLOG_ACTIVITY_REASSIGN = "{\"zh_TW\":\"轉派\",\"en_US\":\"Reassign\",\"zh_CN\":\"转派\"}";

    /**
     * 任务卡的状态-拒绝
     */
    public final static String BACKLOG_ACTIVITY_REJECT = "{\"zh_TW\":\"拒絕\",\"en_US\":\"reject\",\"zh_CN\":\"拒绝\"}";

    /**
     * 任务卡的状态-退回
     */
    public final static String BACKLOG_ACTIVITY_REEXECUTE = "{\"zh_TW\":\"退回\",\"en_US\":\"Return\",\"zh_CN\":\"退回\"}";

    /**
     * 任务卡的状态-加签
     */
    public final static String BACKLOG_ACTIVITY_ADD_TASK = "{\"zh_TW\":\"加簽\",\"en_US\":\"Add Task\",\"zh_CN\":\"加签\"}";

    /**
     * 任务卡的状态-撤回
     */
    public final static String BACKLOG_ACTIVITY_ABORT_TASK = "{\"zh_TW\":\"撤回\",\"en_US\":\"Abort Task\",\"zh_CN\":\"撤回\"}";

    /**
     * 任务卡的状态-退回
     */
    public final static String BACKLOG_ACTIVITY_REAPPROVAL = "{\"zh_TW\":\"退回重簽\",\"en_US\":\"reapproval\",\"zh_CN\":\"退回重签\"}";

    /**
     * 任务卡的状态-撤回重签
     */
    public final static String BACKLOG_ROLLBACK_APPROVE = "{\"zh_TW\":\"撤回重簽\",\"en_US\":\"rollbackApprove\",\"zh_CN\":\"撤回重签\"}";

    /**
     * 任务卡的状态-撤回重办
     */
    public final static String BACKLOG_ROLLBACK = "{\"zh_TW\":\"撤回\",\"en_US\":\"rollback\",\"zh_CN\":\"撤回\"}";

    /**
     * 任务卡的状态-交接
     */
    public final static String BACKLOG_HANDOVER = "{\"zh_TW\":\"交接\",\"en_US\":\"handover\",\"zh_CN\":\"交接\"}";

    /**
     * 任务卡的状态的所有状态
     */
    public final static Map<String, String> backlogStatusMap = new HashMap<>();//NOSONAR

    static {
        backlogStatusMap.put("agree", BACKLOG_ACTIVITY_AGREE);
        backlogStatusMap.put("reassign", BACKLOG_ACTIVITY_REASSIGN);
        backlogStatusMap.put("reject", BACKLOG_ACTIVITY_REJECT);
        backlogStatusMap.put("reexecute", BACKLOG_ACTIVITY_REEXECUTE);
        backlogStatusMap.put("add-task", BACKLOG_ACTIVITY_ADD_TASK);
        backlogStatusMap.put("abort-task", BACKLOG_ACTIVITY_ABORT_TASK);
        backlogStatusMap.put("reapproval", BACKLOG_ACTIVITY_REAPPROVAL);
        backlogStatusMap.put("rollback-approve", BACKLOG_ROLLBACK_APPROVE);
        backlogStatusMap.put("roolback", BACKLOG_ROLLBACK);
        backlogStatusMap.put("handover", BACKLOG_HANDOVER);
    }

    /**
     * 逾期任务卡的操作建议
     */
    public final static String OVERDUE_WORKITEM_OPERATION = "{\"zh_TW\":\"請選擇處理方案\",\"en_US\":\"Please choose a solution\",\"zh_CN\":\"请选择处理方案\"}";

    /**
     * 逾期任务卡 pattern
     */
    public final static String OVERDUE_WORKITEM_PATTER = "UIBOT";

    /**
     * 逾期任务卡 category
     */
    public final static String OVERDUE_WORKITEM_CATEGORY = "UIBOT";

    /**
     * 逾期任务卡 任务 code
     */
    public final static String OVERDUE_WORKITEM_ACTIVITY_CODE = "uibot_overdue_task";

    /**
     * 辅助执行者的任务类型
     */
    public static final int ASSIST_TYPE = 11;

    /**
     * athena不存在的userId列表
     */
    public static final List<String> ATHENA_INVALID_USERID_LIST = Arrays.asList("BPM_PERFORMER");//NOSONAR

    /**
     * 数据一致性异常排除任务卡类型
     */
    public final static Integer DATA_UNIFORMITY_BACKLOG_TYPE = 89;
    /**
     * 数据一致性异常排除任务卡code
     */
    public final static String DATA_UNIFORMITY_ACTIVITY_CODE = "data_uniformity_abnormal_task";

    /**
     * 数据一致性异常排除任务卡名称
     */
    public final static String DATA_UNIFORMITY_BACKLOG_NAME = "{\"zh_TW\":\"業務數據不一致異常排除\",\"en_US\":\"Abnormal Exclude\",\"zh_CN\":\"业务数据不一致异常排除\"}";

    /**
     * 推送钉钉待办pc端url
     */
    public static final String DINGTALK_MSG_PC_URL = "dingtalk://dingtalkclient/action/openapp?corpid=%s&container_type=work_platform&app_id=%s&redirect_type=jump&redirect_url=";
    /**
     * 推送钉钉待办pc端跳转详情url
     */
    public static final String DINGTALK_PC_REDIRECT_URL = "%s/login/dingtalk-login?appId=%s&corpId=%s&dingLog=2&routerLink=task/detail/%s?shareCode=%s";

    /**
     * 推送钉钉待办 移动端 跳转详情url
     */
    public static final String DINGTALK_APP_REDIRECT_UR = "%s/#/?appId=%s&appName=%s&corpId=%s&sourceType=ding_talk&dataId=%s&targetTenantId=%s";
}
