package com.digiwin.athena.eoc.sdk.meta.dto.response;

import lombok.*;
import lombok.experimental.SuperBuilder;

import java.util.List;

@Setter
@Getter
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class EocEmployeeDTO {

    private Long sid;
    /**
     * 员工工号
     */
    private String id;

    /**
     * 员工名称
     */
    private String name;

    private String email;

    private String telephone;

    private Boolean status;

    private List<EocEmployeeDepartDTO> depts;

    private EocEmployeeUserDTO user;

    private Long tenantSid;

    private String userId;

    private String userName;

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class EocEmployeeUserDTO {
        private String id;
        private String name;
        private String email;
        private String telephone;
    }

    @Setter
    @Getter
    @SuperBuilder
    @AllArgsConstructor
    @NoArgsConstructor
    public static class EocEmployeeDepartDTO {
        private Long sid;
        /**
         * 部门ID
         */
        private String id;
        /**
         * 部门名称
         */
        private String name;
        /**
         * 部门主管EOC ID
         */
        private String deptDirectorId;
        /**
         * 是否是主部门
         */
        private Boolean mainDept;
    }
}
