package com.digiwin.athena.eoc.sdk.config;

import com.jugg.agile.framework.core.config.JaPostPropertyHandler;
import com.jugg.agile.framework.core.config.JaProperty;
import com.jugg.agile.framework.core.util.JaStringUtil;

public class EocI18nPostHandler implements JaPostPropertyHandler {
    private static final String BASE_NAME = "spring.messages.basename";
    private static final String EOC_NAME = "i18n/eoc-sdk-messages";

    @Override
    public void addAndCover() {
        String basename = JaProperty.get(BASE_NAME);
        if (JaStringUtil.isEmpty(basename)) {
            JaProperty.getPropertyMap().put(BASE_NAME, EOC_NAME);
        } else {
            JaProperty.getPropertyMap().put(BASE_NAME, basename + "," + EOC_NAME);
        }
    }

    @Override
    public int order() {
        return 13;
    }

}
